// DMBot.cpp : Defines the entry point for the application.
//

#include "stdafx.h"
#include "resource.h"
#include "winamp.h"
#include "Config.h"
#include "PacketBuffer.h"
#include "Statstring.h"
#include "DMEncrypt.h"
//#include "AggressiveOptimize.h"
#include "List2.h"
#include <shellapi.h>

HWND Dlg, Winamp;
HINSTANCE DlgInst;
WNDPROC EditBoxOldWndProc;
LList<char *> Queue;
LList<char *> ProfileNames;

bool connected = false, udpr = false, lastreply = false;
SOCKET s, udp;
HANDLE events[2];
struct sockaddr_in sname;

char replyname[32] = "", laddername[32] = "";
char age[256] = "";
char sex[256] = "";
char location[256] = "";
char description[256] = "";

unsigned long channelslen;
char currentchannel[128] = "";
char timestamp[128] = "";
char menubuf[32] = "";
char channels[2048] = "";

char username[128] = "";
char unname[128] = "";
char password[128] = "";
char cdkey[128] = "";
char server[128] = "";
char homechan[128] = "";
char idle[256] = "";
int showidle, idletype;
PacketBuffer packetbuf;
unsigned long encryptvalue = 0, pingvalue = 0, prof = -1;
unsigned long profnum, tick, idletime = 0;
unsigned speed;
bool joinleave = true;

unsigned long floodtimer = 0, idletimer = 0;

void SetRichEditBackColor(int RichEdit, COLORREF Color);
void __cdecl AppendText(int RichEdit, COLORREF Color, char *Fmt, ...);
void ClearRichEdit(int RichEdit);
void CharFormat(COLORREF color, CHARFORMAT &cf);
void InitImageList(int ListView, int ImgList);
void InsertItem(int ListView, char *item, int icon);
void RemoveItem(int ListView, char *item);
void ModifyItem(int ListView, char *item, int icon);
int GetItemIndex(int ListView, char *item);
void ClearListView(int ListView);
int GetListViewSelectedItem(int ListView);
void GetListViewItemText(int ListView, int item, char *buf);
void SetEditBoxText(int EditBox, char *text);
void AppendEditBoxText(int EditBox, char *text);
void GetEditBoxText(int EditBox, char *text);
void RemoveListBoxItem(int ListBox, int item);
void GetListBoxItemText(int ListBox, int item, char *text);
void AddListBoxItem(int ListBox, char *text);
void ClearListBox(int ListBox);
void DoEvents();
bool Connect(char *szServer);
void Disconnect();
void MsgLoop();
void getvalues(const char *databuf, DWORD *ping, DWORD *flags, char *name, char *txt);
void HexDump(int len, char *buf);
void datahash(unsigned long*param);
void calchashbuf(unsigned long *hash, void *inbuf, int len);
void __cdecl Send(char *fmt, ...);
void TimeStamp(char *buf);
void DisplayProfileDialog(char *databuf);
void RequestProfile(const char *username);
unsigned __int64 GetCycleCount(void);
unsigned cpuspeed(void);
unsigned FixSpeed(unsigned CpuSpeed);
SYSTEMTIME FormatDWORD(DWORD Milliseconds);
BOOL CheckRevision(LPCTSTR lpszFileName1, LPCTSTR lpszFileName2, LPCTSTR lpszFileName3, LPCTSTR lpszValueString, DWORD * lpdwVersion, DWORD * lpdwChecksum, LPSTR lpExeInfoString, LPCTSTR lpszMpqFileName);

LRESULT CALLBACK EditBoxSubclass(HWND EditBox, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	char txt[256] = "";
	switch(uMsg){
	case WM_KEYUP:
		if(wParam == VK_RETURN){
			GetEditBoxText(IDC_SENDBOX, txt);
			strtok(txt, "\r\n\x0a");
			Send("%s", txt);
			return 0;
		}
	case WM_KEYDOWN:
		if(wParam == VK_RETURN)
			return 0;
	case WM_CHAR:
		if(wParam == VK_RETURN)
			return 0;
	}
	return CallWindowProc(EditBoxOldWndProc, EditBox, uMsg, wParam, lParam);
}

BOOL CALLBACK ChannelDialogProc(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	HWND List = GetDlgItem(hDlg, IDC_CHAN_LIST);
	HWND ToAdd = GetDlgItem(hDlg, IDC_CHAN_TOADD);
	HMENU Menu1 = GetMenu(Dlg);
	HMENU Menu2 = GetSubMenu(Menu1, 1);
	char buf[128] = "";
	int buflen = 0;
	switch(uMsg)
	{
	case WM_INITDIALOG:
		{
		EnableMenuItem(Menu2, 1, MF_BYPOSITION | MF_DISABLED);
		FILE *stream = fopen("channels.txt", "r");
		if(stream){
			while(fgets(buf + 1, 127, stream)){
				strtok(buf, "\r\n");
				buf[0] = '*';
				char *p = strchr(buf, 0x0a);
				if(p) *p = 0;
				SendMessage(List, LB_ADDSTRING, 0, (LPARAM)buf);
			}
			fclose(stream);
		}
		while(buflen <= channelslen){
			strcpy(buf, channels + buflen);
			if(strlen(buf))
				SendMessage(List, LB_ADDSTRING, 0, (LPARAM)buf);
			buflen += (strlen(buf) + 1);
		}
		return TRUE;
		}
	case WM_COMMAND:
		{
		if(wParam == MAKEWPARAM(IDC_CHAN_ADD, 0)){
			char buf[128] = "";
			GetWindowText(ToAdd, buf + 1, sizeof(buf) - 1);
			buf[0] = '*';
			if(strlen(buf))
				SendMessage(List, LB_ADDSTRING, 0, (LPARAM)buf);
			SetWindowText(ToAdd, "");
		}
		if(wParam == MAKEWPARAM(IDC_CHAN_REMOVE, 0)){
			int sel = SendMessage(List, LB_GETCURSEL, 0, 0);
			if(sel != LB_ERR)
				SendMessage(List, LB_DELETESTRING, sel, 0);
		}
		if(wParam == MAKEWPARAM(IDC_CHAN_JOIN, 0)){
			char buf[128] = "";
			int sel = SendMessage(List, LB_GETCURSEL, 0, 0);
			if(sel != LB_ERR){
				SendMessage(List, LB_GETTEXT, sel, (LPARAM)buf);
				packetbuf.insert((int)2);
				if(buf[0] == '*')
					packetbuf.insert(buf + 1);
				else
					packetbuf.insert(buf);
				packetbuf.sendpacket(s, 0x0c);
			}
		}
		if(wParam == MAKEWPARAM(IDC_CHAN_DONE, 0)){
			FILE *stream = fopen("channels.txt", "wt");
			if(stream){
				char buf[128] = "";
				int cnt = SendMessage(List, LB_GETCOUNT, 0, 0);
				for(int i = 0; i < cnt; i++){
					SendMessage(List, LB_GETTEXT, i, (LPARAM)buf);
					if(buf[0] == '*')
						fprintf(stream, "%s\n", buf + 1);
				}
				fclose(stream);
			}
			EnableMenuItem(Menu2, 1, MF_BYPOSITION | MF_ENABLED);
			EndDialog(hDlg, 0);
		}
		if(wParam == MAKEWPARAM(IDC_CHAN_CANCEL, 0)){
			EnableMenuItem(Menu2, 1, MF_BYPOSITION | MF_ENABLED);
			EndDialog(hDlg, 0);
		}
		return TRUE;
		}
	}
	return FALSE;
}

BOOL CALLBACK AboutDialogProc(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	HMENU Menu1 = GetMenu(Dlg);
	switch(uMsg)
	{
	case WM_INITDIALOG:
		EnableMenuItem(Menu1, IDM_ABOUT, MF_BYCOMMAND | MF_DISABLED);
	case WM_COMMAND:
		if(wParam == MAKEWPARAM(IDC_ABOUT_OK, 0)){
			EnableMenuItem(Menu1, IDM_ABOUT, MF_BYCOMMAND | MF_ENABLED);
			EndDialog(hDlg, 0);
		}
		return TRUE;
	}
	return FALSE;
}

BOOL CALLBACK ProfileDialogProc(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	HWND Name = GetDlgItem(hDlg, IDC_PNAME);
	HWND Age = GetDlgItem(hDlg, IDC_PAGE);
	HWND Sex = GetDlgItem(hDlg, IDC_PSEX);
	HWND Loc = GetDlgItem(hDlg, IDC_PLOCATION);
	HWND Desc = GetDlgItem(hDlg, IDC_PDESCRIPTION);
	switch(uMsg)
	{
	case WM_INITDIALOG:
		SendMessage(Name, EM_SETREADONLY, TRUE, 0);
		SetWindowText(Name, ProfileNames.Get(profnum));
		SetWindowText(Age, age);
		SetWindowText(Sex, sex);
		SetWindowText(Loc, location);
		SetWindowText(Desc, description);
		if(stricmp(ProfileNames.Get(profnum), unname)){
			SendMessage(Age, EM_SETREADONLY, TRUE, 0);
			SendMessage(Sex, EM_SETREADONLY, TRUE, 0);
			SendMessage(Loc, EM_SETREADONLY, TRUE, 0);
			SendMessage(Desc, EM_SETREADONLY, TRUE, 0);
		}
		return TRUE;
	case WM_COMMAND:
		if(wParam == MAKEWPARAM(IDC_POK, 0)){
			if(!stricmp(ProfileNames.Get(profnum), unname)){
				GetWindowText(Age, age, 256);
				GetWindowText(Sex, sex, 256);
				GetWindowText(Loc, location, 256);
				GetWindowText(Desc, description, 256);
				packetbuf.insert((int)1);
				packetbuf.insert((int)4);
				packetbuf.insert(unname);
				packetbuf.insert("profile\\sex");
				packetbuf.insert("profile\\age");
				packetbuf.insert("profile\\location");
				packetbuf.insert("profile\\description");
				packetbuf.insert(sex);
				packetbuf.insert(age);
				packetbuf.insert(location);
				packetbuf.insert(description);
				packetbuf.sendpacket(s, 0x27);
			}
			EndDialog(hDlg, 0);
		}
		if(wParam == MAKEWPARAM(IDC_PCANCEL, 0))
			EndDialog(hDlg, 0);
		return TRUE;
	}
	return FALSE;
}

BOOL CALLBACK ConfigDialogProc(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	HWND Username = GetDlgItem(hDlg, IDC_CONFIG_USERNAME);
	HWND Password = GetDlgItem(hDlg, IDC_CONFIG_PASSWORD);
	HWND CDKey = GetDlgItem(hDlg, IDC_CONFIG_CDKEY);
	HWND Server = GetDlgItem(hDlg, IDC_CONFIG_SERVER);
	HWND Homechan = GetDlgItem(hDlg, IDC_CONFIG_HOMECHAN);
	HWND Idle = GetDlgItem(hDlg, IDC_CONFIG_IDLE);
	HWND ShowIdle = GetDlgItem(hDlg, IDC_CONFIG_SHOWIDLE);
	HWND IdleTypeCustom = GetDlgItem(hDlg, IDC_CONFIG_CUST);
	HWND IdleTypeTime = GetDlgItem(hDlg, IDC_CONFIG_TIME);
	HWND IdleTypeMp3 = GetDlgItem(hDlg, IDC_CONFIG_MP3);
	HMENU Menu1 = GetMenu(Dlg);
	HMENU Menu2 = GetSubMenu(Menu1, 1);
	switch(uMsg)
	{
	case WM_INITDIALOG:
		EnableMenuItem(Menu2, 0, MF_BYPOSITION | MF_DISABLED);
		SetWindowText(Username, username);
		SetWindowText(Password, password);
		SetWindowText(CDKey, cdkey);
		SetWindowText(Server, server);
		SetWindowText(Homechan, homechan);
		SetWindowText(Idle, idle);
		SendMessage(ShowIdle, BM_SETCHECK, showidle, 0);
		if(idletype == IDLE_CUSTOM)
			SendMessage(IdleTypeCustom, BM_SETCHECK, 1, 0);
		if(idletype == IDLE_TIME)
			SendMessage(IdleTypeTime, BM_SETCHECK, 1, 0);
		if(idletype == IDLE_MP3)
			SendMessage(IdleTypeMp3, BM_SETCHECK, 1, 0);
		return TRUE;
	case WM_COMMAND:
		if(wParam == MAKEWPARAM(IDC_CONFIG_OK, 0)){
			GetWindowText(Username, username, sizeof(username));
			GetWindowText(Password, password, sizeof(password));
			GetWindowText(CDKey, cdkey, sizeof(cdkey));
			GetWindowText(Server, server, sizeof(cdkey));
			GetWindowText(Homechan, homechan, sizeof(homechan));
			showidle = SendMessage(ShowIdle, BM_GETCHECK, 0, 0);
			if(SendMessage(IdleTypeCustom, BM_GETCHECK, 0, 0))
				idletype = IDLE_CUSTOM;
			if(SendMessage(IdleTypeTime, BM_GETCHECK, 0, 0))
				idletype = IDLE_TIME;
			if(SendMessage(IdleTypeMp3, BM_GETCHECK, 0, 0))
				idletype = IDLE_MP3;
			WriteConfig(username, password, cdkey, server, homechan, idle, showidle, idletype);
			LoadConfig(username, password, cdkey, server, homechan, idle, &showidle, &idletype);
			showidle -= 48;
			idletype -= 48;
			EnableMenuItem(Menu2, 0, MF_BYPOSITION | MF_ENABLED);
			EndDialog(hDlg, 0);
			return TRUE;
		}
		if(wParam == MAKEWPARAM(IDC_CONFIG_CANCEL, 0)){
			EnableMenuItem(Menu2, 0, MF_BYPOSITION | MF_ENABLED);
			EndDialog(hDlg, 0);
			return TRUE;
		}
		return TRUE;
	}
	return FALSE;
}

BOOL CALLBACK MainDialogProc(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	HMENU Menu1 = GetMenu(Dlg);
	HMENU Menu2 = GetSubMenu(Menu1, 3);
	HWND Volume = GetDlgItem(hDlg, IDC_VOLUME);
	HICON icon;
	DWORD SliderPos;
	Dlg = hDlg;
	TimeStamp(timestamp);
	switch(uMsg){
	case WM_NOTIFY:
		{
		ENLINK *pLinkInfo;
		pLinkInfo = (ENLINK *)lParam;
		if(pLinkInfo->nmhdr.code == EN_LINK && pLinkInfo->msg == WM_LBUTTONDOWN) {
			char szBuffer[512];
			CHARRANGE crOldSelection;
			SendDlgItemMessage(hDlg, wParam, EM_EXGETSEL, 0, (LPARAM)&crOldSelection);
			SendDlgItemMessage(hDlg, wParam, EM_EXSETSEL, 0, (LPARAM)&pLinkInfo->chrg);
			SendDlgItemMessage(hDlg, wParam, EM_GETSELTEXT, 0, (LPARAM)szBuffer);
			ShellExecute(0, 0, szBuffer, 0, 0, SW_SHOW);
			SendDlgItemMessage(hDlg, wParam, EM_EXSETSEL, 0, (LPARAM)&crOldSelection);
			return FALSE;
		} 
		NMHDR *Header = reinterpret_cast<NMHDR *>(lParam);
		if(wParam == MAKEWPARAM(IDC_VOLUME, 0)){
			Winamp = FindWindow("Winamp v1.x", NULL);
			if(Winamp){
				SliderPos = SendMessage(Volume, TBM_GETPOS, 0, 0);
				SendMessage(Winamp, WM_WA_IPC, SliderPos, IPC_SETVOLUME);
			}
		}
		if(wParam == MAKEWPARAM(IDC_CHANLIST, 0)){
			if(Header->code == NM_RCLICK){
				int sel = GetListViewSelectedItem(IDC_CHANLIST);
				if(sel == -1)
					return TRUE;
				GetListViewItemText(IDC_CHANLIST, sel, menubuf);
				POINT pt;
				GetCursorPos(&pt);
				HMENU menu = LoadMenu(DlgInst, MAKEINTRESOURCE(IDR_LISTMENU));
				menu = GetSubMenu(menu, 0);
				TrackPopupMenu(menu, TPM_LEFTALIGN | TPM_RIGHTBUTTON, pt.x, pt.y, 0, Dlg, NULL);
			}
			if(Header->code == NM_DBLCLK){
				int sel = GetListViewSelectedItem(IDC_CHANLIST);
				if(sel == -1)
					return TRUE;
				GetListViewItemText(IDC_CHANLIST, sel, menubuf);
				AppendEditBoxText(IDC_SENDBOX, menubuf);
			}
		}
		return TRUE;
		}
	case WM_DESTROY:
		SetWindowLong(GetDlgItem(hDlg, IDC_SENDBOX), GWL_WNDPROC, (LONG)EditBoxOldWndProc);
		break;
	case WM_INITDIALOG:
		icon = LoadIcon(DlgInst, MAKEINTRESOURCE(IDI_MAINICON));
		SetRichEditBackColor(IDC_CHATWND, BLACK);
		InitImageList(IDC_CHANLIST, IDB_BNETICONS);
		LoadConfig(username, password, cdkey, server, homechan, idle, &showidle, &idletype);
		Winamp = FindWindow("Winamp v1.x", NULL);
		Queue.Flush(); ProfileNames.Flush();
		SendMessage(Volume, TBM_SETRANGEMIN, TRUE, 0);
		SendMessage(Volume, TBM_SETRANGEMAX, TRUE, 255);
		SendMessage(Volume, TBM_SETPOS, TRUE, 255);
		SendDlgItemMessage(hDlg, IDC_CHATWND, EM_SETEVENTMASK, 0, ENM_LINK);
		SendDlgItemMessage(hDlg, IDC_CHATWND, EM_AUTOURLDETECT, TRUE, 0);
		EditBoxOldWndProc = (WNDPROC)SetWindowLong(GetDlgItem(hDlg, IDC_SENDBOX), GWL_WNDPROC, (LONG)EditBoxSubclass);
		speed = cpuspeed();
		speed = FixSpeed(speed);
		showidle -= 48;
		idletype -= 48;
		return TRUE;
	case WM_CLOSE:
		{
		int ret = MessageBox(hDlg, "Are you sure you want to exit?", "DMBot", MB_YESNO);
		if(ret == IDYES)
		{
			Disconnect();
			EndDialog(hDlg, 0);
			_exit(0);
		}
		return TRUE;
		}
	case WM_COMMAND:
		{
		//list menu items
		Winamp = FindWindow("Winamp v1.x", NULL);
		if(wParam == MAKEWPARAM(IDM_CHANNELS, 0))
			CreateDialog(DlgInst, MAKEINTRESOURCE(IDD_CHANNELS), Dlg, ChannelDialogProc);
		if(wParam == MAKEWPARAM(IDM_LWHOIS, 0))
			Send("/whois %s", menubuf);
		if(wParam == MAKEWPARAM(IDM_LSQUELCH, 0))
			Send("/squelch %s", menubuf);
		if(wParam == MAKEWPARAM(IDM_LUNSQUELCH, 0))
			Send("/unsquelch %s", menubuf);
		if(wParam == MAKEWPARAM(IDM_LBAN, 0))
			Send("/ban %s", menubuf);
		if(wParam == MAKEWPARAM(IDM_LKICK, 0))
			Send("/kick %s", menubuf);
		if(wParam == MAKEWPARAM(IDM_LFADD, 0))
			Send("/f add %s", menubuf);
		if(wParam == MAKEWPARAM(IDM_LFREMOVE, 0))
			Send("/f remove %s", menubuf);
		if(wParam == MAKEWPARAM(IDM_LFPROMOTE, 0))
			Send("/f promote %s", menubuf);
		if(wParam == MAKEWPARAM(IDM_LFDEMOTE, 0))
			Send("/f demote %s", menubuf);
		if(wParam == MAKEWPARAM(IDM_LFLIST, 0))
			Send("/f list");
		if(wParam == MAKEWPARAM(IDM_SSSW, 0))
			Send("/stats %s SSHR", menubuf);
		if(wParam == MAKEWPARAM(IDM_SSC, 0))
			Send("/stats %s STAR", menubuf);
		if(wParam == MAKEWPARAM(IDM_SBW, 0))
			Send("/stats %s SEXP", menubuf);
		if(wParam == MAKEWPARAM(IDM_SSCJ, 0))
			Send("/stats %s JSTR", menubuf);
		if(wParam == MAKEWPARAM(IDM_SWAR2, 0))
			Send("/stats %s WAR2", menubuf);
		if(wParam == MAKEWPARAM(IDM_LCOPYNAME, 0))
			AppendEditBoxText(IDC_SENDBOX, menubuf);
		if(wParam == MAKEWPARAM(IDM_LPROFILE, 0)){
			ProfileNames.Add(menubuf);
			RequestProfile(menubuf);
		}
		if(wParam == MAKEWPARAM(IDM_LDRSSW, 0)){
			packetbuf.insert("RHSS", 4);
			packetbuf.insert((int)1);
			packetbuf.insert((int)0);
			packetbuf.insert(menubuf);
			packetbuf.sendpacket(s, 0x2f);
			strcpy(laddername, menubuf);
		}
		if(wParam == MAKEWPARAM(IDM_LDRSC, 0)){
			packetbuf.insert("RATS", 4);
			packetbuf.insert((int)1);
			packetbuf.insert((int)0);
			packetbuf.insert(menubuf);
			packetbuf.sendpacket(s, 0x2f);
			strcpy(laddername, menubuf);
		}
		if(wParam == MAKEWPARAM(IDM_LDRBW, 0)){
			packetbuf.insert("PXES", 4);
			packetbuf.insert((int)1);
			packetbuf.insert((int)0);
			packetbuf.insert(menubuf);
			packetbuf.sendpacket(s, 0x2f);
			strcpy(laddername, menubuf);
		}
		if(wParam == MAKEWPARAM(IDM_LDRSCJ, 0)){
			packetbuf.insert("RTSJ", 4);
			packetbuf.insert((int)1);
			packetbuf.insert((int)0);
			packetbuf.insert(menubuf);
			packetbuf.sendpacket(s, 0x2f);
			strcpy(laddername, menubuf);
		}
		if(wParam == MAKEWPARAM(IDM_LDRWAR2, 0)){
			packetbuf.insert("NB2W", 4);
			packetbuf.insert((int)1);
			packetbuf.insert((int)0);
			packetbuf.insert(menubuf);
			packetbuf.sendpacket(s, 0x2f);
			strcpy(laddername, menubuf);
		}

		if(wParam == MAKEWPARAM(IDM_ABOUT, 0))
			CreateDialog(DlgInst, MAKEINTRESOURCE(IDD_ABOUT), Dlg, AboutDialogProc);
		if(wParam == MAKEWPARAM(IDM_CONFIGURE, 0))
			CreateDialog(DlgInst, MAKEINTRESOURCE(IDD_CONFIG), Dlg, ConfigDialogProc);
		if(wParam == MAKEWPARAM(IDM_EXIT, 0)){
			EndDialog(hDlg, 0);
			_exit(0);
		}
		if(wParam == MAKEWPARAM(IDM_CONNECT, 0)){
			AppendText(IDC_CHATWND, WHITE, "%s", timestamp);
			AppendText(IDC_CHATWND, WHITE, "Attempting to connect to %s...\n", server);
			connected = Connect(server);
			if(connected){
				AppendText(IDC_CHATWND, WHITE, "%s", timestamp);
				AppendText(IDC_CHATWND, GREEN, "Connected!\n");
				MsgLoop();
			}
			else{
				AppendText(IDC_CHATWND, WHITE, "%s", timestamp);
				AppendText(IDC_CHATWND, RED, "Connect() failed!\n");
			}
		}
		if(wParam == MAKEWPARAM(IDM_DISCONNECT, 0))
			Disconnect();
		if(wParam == MAKEWPARAM(IDC_PREV, 0))
			SendMessage(Winamp, WM_COMMAND, WINAMP_BUTTON1, 0);
		if(wParam == MAKEWPARAM(IDC_PLAY, 0))
			SendMessage(Winamp, WM_COMMAND, WINAMP_BUTTON2, 0);
		if(wParam == MAKEWPARAM(IDC_PAUSE, 0))
			SendMessage(Winamp, WM_COMMAND, WINAMP_BUTTON3, 0);
		if(wParam == MAKEWPARAM(IDC_STOP, 0))
			SendMessage(Winamp, WM_COMMAND, WINAMP_BUTTON4, 0);
		if(wParam == MAKEWPARAM(IDC_NEXT, 0))
			SendMessage(Winamp, WM_COMMAND, WINAMP_BUTTON5, 0);
		if(wParam == MAKEWPARAM(IDC_MUTE, 0))
			SendMessage(Volume, TBM_SETPOS, TRUE, 0);
		if(wParam == MAKEWPARAM(IDM_CLEARWND, 0))
			ClearRichEdit(IDC_CHATWND);
		if(wParam == MAKEWPARAM(IDC_SHOWMP3, 0))
		{
			char song[200] = "";
			if(GetWindowText(Winamp, song, sizeof(song))){
				for(int i = 0; i < (int)strlen(song); i++){
					if(song[i] == ' ') break;
				} i++;
				memmove(song, song + i, strlen(song) - i);
				char *p = strstr(song, " - Winamp");
				if(p) *p = NULL;
			}
			char tmpbuf[256] = "";
			sprintf(tmpbuf, "/me now playing: %s - DMBot 3.0.0", song);
			char *p = new char[strlen(tmpbuf) + 1]; strcpy(p, tmpbuf);
			Queue.Add(p);
			packetbuf.insert((int)0x1b);
			packetbuf.insert((int)0);
			packetbuf.insert("icons.bni");
			packetbuf.sendpacket(s, 0x33);
		}
		return TRUE;
		}
	case WM_CTLCOLOREDIT:
	case WM_CTLCOLORSTATIC:
		SetBkColor((HDC)wParam, 0x000000);
		SetTextColor((HDC)wParam, 0xFFFFFF);
		return (BOOL)GetStockObject(BLACK_BRUSH);
	}
	return FALSE;
}

int APIENTRY WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
 	// TODO: Place code here.
	DlgInst = hInstance;
	HINSTANCE RichEditDLL = LoadLibrary("RichEd32.dll");
	InitCommonControls();
	DialogBox(hInstance, MAKEINTRESOURCE(IDD_UNF), NULL, MainDialogProc);
	FreeLibrary(RichEditDLL);
	return 0;
}

void SetRichEditBackColor(int RichEdit, COLORREF Color)
{
	HWND REdit = GetDlgItem(Dlg, RichEdit);
	SendMessage(REdit, EM_SETBKGNDCOLOR, FALSE, Color);
}

void ClearRichEdit(int RichEdit)
{
	HWND REdit = GetDlgItem(Dlg, RichEdit);
	SetWindowText(REdit, "");
}

void __cdecl AppendText(int RichEdit, COLORREF Color, char *Fmt, ...)
{
	char txt[2048] = "";
	va_list argptr;
	va_start(argptr, Fmt);
	vsprintf(txt, Fmt, argptr);
	va_end(argptr);
	CHARFORMAT cf;
	HWND REdit = GetDlgItem(Dlg, RichEdit);
	SendMessage(REdit, EM_SETSEL, -1, -1);
	CharFormat(Color, cf);
	SendMessage(REdit, EM_SETCHARFORMAT, SCF_SELECTION, (LPARAM)&cf);
	SendMessage(REdit, EM_REPLACESEL, FALSE, (LPARAM)txt);
	SendMessage(REdit, EM_SETSEL, -1, -1);
}

void CharFormat(COLORREF color, CHARFORMAT &cf)
{
	cf.cbSize = sizeof(CHARFORMAT);
	cf.dwMask = CFM_COLOR | CFM_FACE | CFM_SIZE;
	cf.dwEffects = CFE_PROTECTED;
	cf.yHeight = 170;
	cf.yOffset = 0;
	cf.crTextColor = color;
	cf.bCharSet = DEFAULT_CHARSET;
	cf.bPitchAndFamily = DEFAULT_PITCH;
	strcpy(cf.szFaceName, "Verdana");
}

void InitImageList(int ListView, int ImgList)
{
	HWND LView = GetDlgItem(Dlg, ListView);
	HIMAGELIST hList = ImageList_Create(28, 14, ILC_COLOR16, 8, 1);
	HBITMAP BnetIcons = LoadBitmap(DlgInst, MAKEINTRESOURCE(IDB_BNETICONS));
	ImageList_Add(hList, BnetIcons, NULL);
	SendMessage(LView, LVM_SETIMAGELIST, LVSIL_SMALL, (LPARAM)hList);
	SendMessage(LView, LVM_SETBKCOLOR, 0, (LPARAM)BLACK);
	SendMessage(LView, LVM_SETTEXTBKCOLOR, 0, (LPARAM)BLACK);
	SendMessage(LView, LVM_SETTEXTCOLOR, 0, (LPARAM)LIGHTBLUE);
}

void GetListViewItemText(int ListView, int item, char *buf)
{
	HWND LView = GetDlgItem(Dlg, ListView);
	char buffer[32] = "";
	LVITEM lvi;
	lvi.pszText = buffer;
	lvi.iSubItem = 0;
	lvi.cchTextMax = sizeof(buffer);
	SendMessage(LView, LVM_GETITEMTEXT, item, (LPARAM)&lvi);
	strcpy(buf, buffer);
}

int GetListViewSelectedItem(int ListView)
{
	HWND LView = GetDlgItem(Dlg, ListView);
	int itemcount = SendMessage(LView, LVM_GETITEMCOUNT, 0, 0);
	for(int i = 0; i < itemcount; i++){
		DWORD state = SendMessage(LView, LVM_GETITEMSTATE, i, LVIS_SELECTED);
		if(state == LVIS_SELECTED)
			return i;
	}
	return -1;
}

void InsertItem(int ListView, char *item, int icon)
{
	HWND LView = GetDlgItem(Dlg, ListView);
	LVITEM *lvi = new LVITEM;
	lvi->mask =  LVIF_IMAGE | LVIF_TEXT;
	lvi->iItem = (int)SendMessage(LView, LVM_GETITEMCOUNT, 0, 0);
	lvi->iSubItem = 0;
	lvi->pszText = item;
	lvi->iImage = icon;
	SendMessage(LView, LVM_INSERTITEM, 0, (LPARAM)lvi);
	SendMessage(LView, LVM_ARRANGE, LVA_ALIGNLEFT, 0);
	int itemcount = (int)SendMessage(LView, LVM_GETITEMCOUNT, 0, 0);
	char txt[128] = "";
	sprintf(txt, "%s (%i)", currentchannel, itemcount);
	SetEditBoxText(IDC_CHAN, txt);
}

int GetItemIndex(int ListView, char *item)
{
	HWND LView = GetDlgItem(Dlg, ListView);
	int ItemCount = SendMessage(LView, LVM_GETITEMCOUNT, 0, 0);
	for(int i = 0; i < ItemCount; i++){
		char buffer[32] = "";
		ListView_GetItemText(LView, i, 0, buffer, sizeof(buffer));
		if(!stricmp(buffer, item))
			return i;
	}
	return -1;
}

void RemoveItem(int ListView, char *item)
{
	HWND LView = GetDlgItem(Dlg, ListView);
	int ItemCount = SendMessage(LView, LVM_GETITEMCOUNT, 0, 0);
	for(int i = 0; i < ItemCount; i++){
		char buffer[32] = "";
		ListView_GetItemText(LView, i, 0, buffer, sizeof(buffer));
		if(!stricmp(buffer, item))
			SendMessage(LView, LVM_DELETEITEM, i, 0);
	}
	SendMessage(LView, LVM_ARRANGE, LVA_ALIGNLEFT, 0);
	int itemcount = (int)SendMessage(LView, LVM_GETITEMCOUNT, 0, 0);
	char txt[128] = "";
	sprintf(txt, "%s (%i)", currentchannel, itemcount);
	SetEditBoxText(IDC_CHAN, txt);
}

void ModifyItem(int ListView, char *item, int icon)
{
	HWND LView = GetDlgItem(Dlg, ListView);
	int itemcount = SendMessage(LView, LVM_GETITEMCOUNT, 0, 0);
	int pos = GetItemIndex(IDC_CHANLIST, item);
	LVITEM lvi;
	lvi.mask =  LVIF_IMAGE | LVIF_TEXT;
	lvi.iItem = pos;
	lvi.iSubItem = 0;
	lvi.pszText = item;
	lvi.iImage = icon;
	SendMessage(LView, LVM_DELETEITEM, pos, 0);
	SendMessage(LView, LVM_INSERTITEM, 0, (LPARAM)&lvi);
}

void ClearListView(int ListView)
{
	HWND LView = GetDlgItem(Dlg, ListView);
	SendMessage(LView, LVM_DELETEALLITEMS, 0, 0);
}

void AddListBoxItem(int ListBox, char *text)
{
	HWND LBox = GetDlgItem(Dlg, ListBox);
	SendMessage(LBox, LB_ADDSTRING, 0, (LPARAM)text);
}

void RemoveListBoxItem(int ListBox, int item)
{
	HWND LBox = GetDlgItem(Dlg, ListBox);
	SendMessage(LBox, LB_DELETESTRING, item, 0);
}

void GetListBoxItemText(int ListBox, int item, char *text)
{
	HWND LBox = GetDlgItem(Dlg, ListBox);
	SendMessage(LBox, LB_GETTEXT, item, (LPARAM)text);
}

void ClearListBox(int ListBox)
{
	HWND LBox = GetDlgItem(Dlg, ListBox);
	SendMessage(LBox, LB_RESETCONTENT, 0, 0);
}

void SetEditBoxText(int EditBox, char *text)
{
	HWND EBox = GetDlgItem(Dlg, EditBox);
	SetWindowText(EBox, text);
}

void GetEditBoxText(int EditBox, char *text)
{
	HWND EBox = GetDlgItem(Dlg, EditBox);
	GetWindowText(EBox, text, 256);
}

void AppendEditBoxText(int EditBox, char *text)
{
	HWND EBox = GetDlgItem(Dlg, EditBox);
	char buffer[256] = "";
	GetWindowText(EBox, buffer, sizeof(buffer));
	sprintf(buffer, "%s%s", buffer, text);
	SetWindowText(EBox, buffer);
}

void DoEvents() 
{ 
	MSG Msg; 
	while(PeekMessage(&Msg,NULL,0,0,PM_REMOVE))
	{
		if(Msg.message == WM_QUIT) break;
		TranslateMessage(&Msg); 
		DispatchMessage(&Msg);
	}
}

bool Connect(char *szServer){
	if(connected)
		Disconnect();
	//closesocket(udp);
	//udp = INVALID_SOCKET;
	s = INVALID_SOCKET;
	SetEditBoxText(IDC_CHAN, "");
	ClearListView(IDC_CHANLIST);
	WSADATA wsadata;
	if(WSAStartup(0x101,&wsadata)) 
	return false;
	if(wsadata.wVersion != 0x101){
		WSACleanup();
		return false;
	}
	struct hostent *hp;
	memset(&sname, '\0', sizeof(sname));
	sname.sin_family = AF_INET;
	sname.sin_port = htons(6112);
	char *p = szServer;
	while(*p && (isdigit(*p) || (*p == '.')))
		p++;
	if(*p){
		hp = gethostbyname(szServer);
		if(hp == 0)
			return false;
		memcpy(&sname.sin_addr, hp->h_addr, hp->h_length);
	}
	else
		sname.sin_addr.s_addr = inet_addr(szServer);
	s = socket(PF_INET, SOCK_STREAM, IPPROTO_TCP);
	//udp = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
	if(s == INVALID_SOCKET)
		return false;
	//if(udp == INVALID_SOCKET){
	//	AppendText(IDC_CHATWND, WHITE, "%s", timestamp);
	//	AppendText(IDC_CHATWND, RED, "UDP communication failed to initialize!\n");
	//	return false;
	//}
	if(connect(s, (struct sockaddr *)&sname, sizeof(sname)))
		return false;
	events[0] = CreateEvent(0, 0, 0, 0);
	WSAResetEvent(events[0]);
	WSAEventSelect(s, events[0], 0);
	WSAEventSelect(s, events[0], FD_READ | FD_CLOSE);
	return true;
}

void Disconnect()
{
	shutdown(s, SD_BOTH);
	closesocket(s);
	//closesocket(udp);
	//udp = INVALID_SOCKET;
	s = INVALID_SOCKET;
	WSACleanup();
	ClearListView(IDC_CHANLIST);
	AppendText(IDC_CHATWND, WHITE, "%s", timestamp);
	AppendText(IDC_CHATWND, RED, "Disconnected.\n");
	SetEditBoxText(IDC_CHAN, "");
	connected = false;
	lastreply = false;
	idletimer = 0;
}

void __cdecl Send(char *fmt, ...)
{
	char txt[256] = "";
	va_list argptr;
	va_start(argptr, fmt);
	vsprintf(txt, fmt, argptr);
	va_end(argptr);
	char txt2[256] = "";
	char tmp[256] = "";
	if(txt[0] == '/'){
		if(!strnicmp(txt, "/profile ", 9)){
			RequestProfile(txt + 9);
			SetEditBoxText(IDC_SENDBOX, "");
			idletimer = GetTickCount() + 180000;
			idletime = 0;
			return;
		}
		if(!strnicmp(txt, "/ladder ", 8)){
			char junk[32] = "", arg1[32] = "", arg2[32] = "";
			int count = sscanf(txt, "%s %s %s", junk, arg1, arg2);
			if(count == 3){
			if(!stricmp(arg2, "SSHR")){
				packetbuf.insert("RHSS", 4);
				packetbuf.insert((int)1);
				packetbuf.insert((int)0);
				packetbuf.insert(arg1);
				packetbuf.sendpacket(s, 0x2f);
				strcpy(laddername, arg1);
			}
			if(!stricmp(arg2, "STAR")){
				packetbuf.insert("RATS", 4);
				packetbuf.insert((int)1);
				packetbuf.insert((int)0);
				packetbuf.insert(arg1);
				packetbuf.sendpacket(s, 0x2f);
				strcpy(laddername, arg1);
			}
			if(!stricmp(arg2, "SEXP")){
				packetbuf.insert("PXES", 4);
				packetbuf.insert((int)1);
				packetbuf.insert((int)0);
				packetbuf.insert(arg1);
				packetbuf.sendpacket(s, 0x2f);
				strcpy(laddername, arg1);
			}
			if(!stricmp(arg2, "JSTR")){
				packetbuf.insert("RTSJ", 4);
				packetbuf.insert((int)1);
				packetbuf.insert((int)0);
				packetbuf.insert(arg1);
				packetbuf.sendpacket(s, 0x2f);
				strcpy(laddername, arg1);
			}
			if(!stricmp(arg2, "W2BN")){
				packetbuf.insert("NB2W", 4);
				packetbuf.insert((int)1);
				packetbuf.insert((int)0);
				packetbuf.insert(arg1);
				packetbuf.sendpacket(s, 0x2f);
				strcpy(laddername, arg1);
			}
			}
			SetEditBoxText(IDC_SENDBOX, "");
			idletimer = GetTickCount() + 180000;
			idletime = 0;
			return;
		}
		if(!strnicmp(txt, "/join ", 6)){
			packetbuf.insert((int)2);
			packetbuf.insert(txt + 6);
			packetbuf.sendpacket(s, 0x0c);
			SetEditBoxText(IDC_SENDBOX, "");
			idletimer = GetTickCount() + 180000;
			idletime = 0;
			return;
		}
		if(!strnicmp(txt, "/uptime", 7)){
			SYSTEMTIME a = FormatDWORD(GetTickCount() - tick);
			SYSTEMTIME b = FormatDWORD(GetTickCount());
			SYSTEMTIME c = FormatDWORD(pingvalue);
			AppendText(IDC_CHATWND, WHITE, "%s", timestamp);
			AppendText(IDC_CHATWND, YELLOW, "Bot uptime: %d days, %d hours, %d minutes, %d seconds\n", a.wDay, a.wHour, a.wMinute, a.wSecond);
			AppendText(IDC_CHATWND, WHITE, "%s", timestamp);
			AppendText(IDC_CHATWND, YELLOW, "System uptime: %d days, %d hours, %d minutes, %d seconds\n", b.wDay, b.wHour, b.wMinute, b.wSecond);
			AppendText(IDC_CHATWND, WHITE, "%s", timestamp);
			AppendText(IDC_CHATWND, YELLOW, "Server uptime: %d days, %d hours, %d minutes, %d seconds\n", c.wDay, c.wHour, c.wMinute, c.wSecond);
			SetEditBoxText(IDC_SENDBOX, "");
			idletimer = GetTickCount() + 180000;
			idletime = 0;
			return;
		}
		if(!strnicmp(txt, "/sysinfo", 8)){
			MEMORYSTATUS memstat;
			GlobalMemoryStatus(&memstat);
			SYSTEM_INFO sysinfo;
			GetSystemInfo(&sysinfo);
			char buf[64] = "";
			switch(sysinfo.wProcessorArchitecture)
			{
			case PROCESSOR_ARCHITECTURE_INTEL:
				strcpy(buf, "Intel");
				break;
			case PROCESSOR_ARCHITECTURE_MIPS:
				strcpy(buf, "MIPS");
				break;
			case PROCESSOR_ARCHITECTURE_ALPHA:
				strcpy(buf, "Alpha");
				break;
			case PROCESSOR_ARCHITECTURE_PPC:
				strcpy(buf, "PowerPC");
				break;
			case PROCESSOR_ARCHITECTURE_UNKNOWN:
				strcpy(buf, "Unknown");
				break;
			}
			AppendText(IDC_CHATWND, WHITE, "%s", timestamp);
			AppendText(IDC_CHATWND, YELLOW, "Total physical memory: %ld KB, total free memory: %ld KB, running on %ld %s %ld processor(s) operating at %u mhz%s\n", memstat.dwTotalPhys / 1024, memstat.dwAvailPhys / 1024, sysinfo.dwNumberOfProcessors, buf, sysinfo.dwProcessorType, speed, (sysinfo.dwNumberOfProcessors > 1) ? " each.":".");
			SetEditBoxText(IDC_SENDBOX, "");
			idletimer = GetTickCount() + 180000;
			idletime = 0;
			return;
		}
		if(!strnicmp(txt, "/reply ", 7)){
			sprintf(tmp, "/w %s %s", replyname, txt + 7);
			char *p = new char[strlen(tmp) + 1]; strcpy(p, tmp);
			Queue.Add(p);
			packetbuf.insert((int)0x1b);
			packetbuf.insert((int)0);
			packetbuf.insert("icons.bni");
			packetbuf.sendpacket(s, 0x33);
			SetEditBoxText(IDC_SENDBOX, "");
			idletimer = GetTickCount() + 180000;
			idletime = 0;
			return;
		}
		if(!strnicmp(txt, "/rejoin", 7)){
			packetbuf.sendpacket(s, 0x10);
			packetbuf.insert((int)2);
			packetbuf.insert(currentchannel);
			packetbuf.sendpacket(s, 0x0c);
			SetEditBoxText(IDC_SENDBOX, "");
			idletimer = GetTickCount() + 180000;
			idletime = 0;
			return;
		}
	}
	char *p = new char[strlen(txt) + 1]; strcpy(p, txt);
	Queue.Add(p);
	packetbuf.insert((int)0x1b);
	packetbuf.insert((int)0);
	packetbuf.insert("icons.bni");
	packetbuf.sendpacket(s, 0x33);
	SetEditBoxText(IDC_SENDBOX, "");
	idletimer = GetTickCount() + 180000;
	idletime = 0;
}

void MsgLoop()
{
	char tmp[32] = "";
	char buffer[20000] = "";
	char packetdata[5000] = "";
	char packetid = 0;
	unsigned short packetlen = 0;
	char chanbuf[128] = "";
	unsigned long ladder;

	char mbtitle[128] = "", mbtext[128] = "";
	unsigned long mbstyle = 0;

	char mpqname[128] = "", hashcmd[256] = "", exeinfo[256] = "";
	unsigned long version, checksum;
	unsigned long passwordhash[7], createhash[5];

	char name[32] = "", txt[256] = "", stats[512] = "", cdkeyname[512] = "", prog[8] = "";
	unsigned long ping = 0, flags = 0;
	unsigned long lasttick = 0;
	unsigned long rpacketpos = 0, rpacketlen = 0;

	tick = GetTickCount();
	send(s, "\x1", 1, 0);
	packetbuf.insert((int)1);
	packetbuf.insert((int)0); 
	packetbuf.insert((int)0);
	packetbuf.insert((int)0);
	packetbuf.insert((int)0);
	packetbuf.insert("Mr");
	packetbuf.insert("Unf");
	packetbuf.sendpacket(s, 0x1e);

	packetbuf.insert((int)0);
	packetbuf.insert((int)0);
	packetbuf.insert((int)0);
	packetbuf.insert((int)0);
	packetbuf.insert((int)0);
	packetbuf.insert((int)0);
	packetbuf.insert((int)0);
	packetbuf.insert((int)0);
	packetbuf.insert("esc");
	packetbuf.insert("USA");
	packetbuf.insert("USA");
	packetbuf.insert("United States");
	packetbuf.sendpacket(s, 0x12);

	packetbuf.insert("68XIRTSJ", 8);
	packetbuf.insert((int)0xa9);
	packetbuf.insert((int)0);
	packetbuf.sendpacket(s, 0x06);
	
	while(connected){
		idletime += GetTickCount() - lasttick;
		lasttick = GetTickCount();
		TimeStamp(timestamp);
		DWORD waitresult = WaitForSingleObject(events[0], 10);
		if(waitresult == WAIT_TIMEOUT)
		{
			if(GetTickCount() >= floodtimer && lastreply){
				if(Queue.Count() > 0){
					packetbuf.insert(Queue.Get(0));
					packetbuf.sendpacket(s, 0x0e);
					char *tmpbuf = Queue.Get(0);
					if(tmpbuf[0] != '/'){
						AppendText(IDC_CHATWND, WHITE, "%s", timestamp);
						AppendText(IDC_CHATWND, LIGHTBLUE, "<%s> %s\n", unname, Queue.Get(0));
					}
					floodtimer = GetTickCount() + (strlen(Queue.Get(0)) * 10 + 1500);
					Queue.Remove(0);
					lastreply = false;
				}
			}
			if(GetTickCount() >= idletimer && idletimer != 0 && showidle == 1){
				if(idletype == IDLE_CUSTOM){
					char *p = new char[strlen(idle) + 1]; strcpy(p, idle);
					Queue.Add(p);
					packetbuf.insert((int)0x1b);
					packetbuf.insert((int)0);
					packetbuf.insert("icons.bni");
					packetbuf.sendpacket(s, 0x33);
				}
				if(idletype == IDLE_TIME){
					char tmpbuf[256] = "";
					SYSTEMTIME a = FormatDWORD(idletime);
					sprintf(tmpbuf, "/me Idle: %d days, %d hours, %d minutes, %d seconds", a.wDay, a.wHour, a.wMinute, a.wSecond);
					char *p = new char[strlen(tmpbuf) + 1]; strcpy(p, tmpbuf);
					Queue.Add(p);
					packetbuf.insert((int)0x1b);
					packetbuf.insert((int)0);
					packetbuf.insert("icons.bni");
					packetbuf.sendpacket(s, 0x33);
				}
				if(idletype == IDLE_MP3){
					char song[200] = "";
					if(GetWindowText(Winamp, song, sizeof(song))){
						for(int i = 0; i < (int)strlen(song); i++){
							if(song[i] == ' ') break;
						} i++;
						memmove(song, song + i, strlen(song) - i);
						char *p = strstr(song, " - Winamp");
						if(p) *p = NULL;
					}
					char tmpbuf[256] = "";
					sprintf(tmpbuf, "/me now playing: %s - DMBot 3.0.0", song);
					char *p = new char[strlen(tmpbuf) + 1]; strcpy(p, tmpbuf);
					Queue.Add(p);
					packetbuf.insert((int)0x1b);
					packetbuf.insert((int)0);
					packetbuf.insert("icons.bni");
					packetbuf.sendpacket(s, 0x33);
				}
				idletimer = GetTickCount() + 180000;
			}
		}
		if(waitresult == WAIT_OBJECT_0){
			int buflen = 0;
			int recvlen = recv(s, buffer + buflen, sizeof(buffer) - buflen, 0);
			if(!recvlen || recvlen == SOCKET_ERROR){
				Disconnect();
				return;
			}
			buflen += recvlen;
			while((int)buflen >= 4 && connected && (unsigned char)buffer[0] == 0xff){
				packetid = buffer[1];
				packetlen = *(unsigned short *)(buffer + 2);
				memcpy(packetdata, buffer, packetlen);
				//HexDump(packetlen, packetdata);
				switch(packetid){
				case 0x00:
					//Keep alive
					packetbuf.sendpacket(s, 0x0);
					break;
				case 0x06:
					//Mpq name & hash command
					strcpy(mpqname, buffer + 12);
					strcpy(hashcmd, buffer + 25);
					if(!CheckRevision("jstr\\starcraftj.exe", "jstr\\storm.dll", "jstr\\battle.snp", hashcmd, &version, &checksum, exeinfo, mpqname)){
						AppendText(IDC_CHATWND, WHITE, "%s", timestamp);
						AppendText(IDC_CHATWND, RED, "CheckRevision() failed!\n");
						Disconnect();
						return;
					}
					AppendText(IDC_CHATWND, WHITE, "%s", timestamp);
					AppendText(IDC_CHATWND, WHITE, "Checking versions...\n");
					packetbuf.insert("68XIRTSJ", 8);
					packetbuf.insert((int)0xa9);
					packetbuf.insert(version);
					packetbuf.insert(checksum);
					packetbuf.insert(exeinfo);
					packetbuf.sendpacket(s, 0x07);
					break;
				case 0x07:
					//Version check result
					if(buffer[4] != 0x02){
						AppendText(IDC_CHATWND, WHITE, "%s", timestamp);
						AppendText(IDC_CHATWND, RED, "Version check failed!\n");
						Disconnect();
						return;
					}
					AppendText(IDC_CHATWND, WHITE, "%s", timestamp);
					AppendText(IDC_CHATWND, GREEN, "Passed version check!\n");
					packetbuf.insert("tenb", 4);
					packetbuf.sendpacket(s, 0x14);
					packetbuf.sendpacket(s, 0x2d);
					packetbuf.insert((int)0x1b);
					packetbuf.insert((int)0);
					packetbuf.insert("bnserver.ini");
					packetbuf.sendpacket(s, 0x33);
					AppendText(IDC_CHATWND, WHITE, "%s", timestamp);
					AppendText(IDC_CHATWND, WHITE, "Checking CDKey...\n");
					//this is where cdkey packet would be ^^
					break;
				case 0x19:
					//Message box
					mbstyle = *(unsigned long *)(buffer + 4);
					strcpy(mbtext, buffer + 8);
					strcpy(mbtitle, buffer + (9 + strlen(mbtext)));
					MessageBox(Dlg, mbtext, mbtitle, (UINT)mbstyle);
					break;
				case 0x1d:
					//Random encrypt value
					encryptvalue = *(unsigned long *)(buffer + 8);
					packetbuf.insert((int)9);
					packetbuf.insert(buffer + 8, 4);
					packetbuf.insert(buffer + 4, 4);
					packetbuf.sendpacketto(udp, server, 6112);
					break;
				case 0x25:
					//Ping
					pingvalue = *(unsigned long *)(buffer + 4);
					packetbuf.insert((int)pingvalue);
					packetbuf.sendpacket(s, 0x25);
					break;
				case 0x26:
					//Profile
					profnum = *(unsigned long *)(buffer + 12);
					DisplayProfileDialog(buffer);
					break;
				case 0x30:
					strcpy(cdkeyname, buffer + 8);
					if(buffer[4] != 0x01)
					{
						if(buffer[4] == 0x02)
						{
							AppendText(IDC_CHATWND, WHITE, "%s", timestamp);
							AppendText(IDC_CHATWND, RED, "CDKey invalid!\r\n");
							Disconnect();
							return;
						}
						if(buffer[4] == 0x03)
						{
							AppendText(IDC_CHATWND, WHITE, "%s", timestamp);
							AppendText(IDC_CHATWND, RED, "CDKey invalid for this game!\r\n");
							Disconnect();
							return;
						}
						if(buffer[4] == 0x05)
						{	
							AppendText(IDC_CHATWND, WHITE, "%s", timestamp);
							AppendText(IDC_CHATWND, RED, "CDKey in use by: %s!\r\n", cdkeyname);
							Disconnect();
							return;
						}
					}
					AppendText(IDC_CHATWND, WHITE, "%s", timestamp);
					AppendText(IDC_CHATWND, GREEN, "CDKey accepted, logging on...\r\n");
					passwordhash[0] = GetTickCount();
					passwordhash[1] = encryptvalue;
					calchashbuf(passwordhash + 2, password, strlen(password));
					calchashbuf(passwordhash + 2, passwordhash, 7 * sizeof(DWORD));
					packetbuf.insert(passwordhash, 7 * sizeof(DWORD));
					packetbuf.insert(username);
					packetbuf.sendpacket(s, 0x29);
					break;
				case 0x29:
					if(buffer[4] != 0x01){
						AppendText(IDC_CHATWND, WHITE, "%s", timestamp);
						AppendText(IDC_CHATWND, RED, "Login failed! Attempting to create account...\n");
						calchashbuf(createhash, password, strlen(password));
						packetbuf.insert(createhash, 5 * sizeof(DWORD));
						packetbuf.insert(username);
						packetbuf.sendpacket(s, 0x2a);
						break;
					}
					AppendText(IDC_CHATWND, WHITE, "%s", timestamp);
					AppendText(IDC_CHATWND, GREEN, "Login accepted!\n");
					packetbuf.insert(username);
					packetbuf.insert("GAME DMBot 3.0.0 by DarkMinion");
					packetbuf.sendpacket(s, 0x0a);
					packetbuf.insert("RTSJ", 4);
					packetbuf.sendpacket(s, 0x0b);
					packetbuf.insert((int)0);
					packetbuf.insert(homechan);
					packetbuf.sendpacket(s, 0x0c);
					break;
				case 0x2a:
					if(buffer[4] != 0x01)
					{
						AppendText(IDC_CHATWND, WHITE, "%s", timestamp);
						AppendText(IDC_CHATWND, RED, "Account create failed!\n");
						Disconnect();
						return;
					}
					AppendText(IDC_CHATWND, WHITE, "%s", timestamp);
					AppendText(IDC_CHATWND, GREEN, "Account successfully created! Logging on...\n");
					passwordhash[0] = GetTickCount();
					passwordhash[1] = encryptvalue;
					calchashbuf(passwordhash + 2, password, strlen(password));
					calchashbuf(passwordhash + 2, passwordhash, 7 * sizeof(DWORD));
					packetbuf.insert(passwordhash, 7 * sizeof(DWORD));
					packetbuf.insert(username);
					packetbuf.sendpacket(s, 0x29);
					break;
				case 0x2f:
					ladder = *(unsigned long *)(buffer + 4);
					AppendText(IDC_CHATWND, WHITE, "%s", timestamp);
					if(ladder == 0xffffffff)
						AppendText(IDC_CHATWND, RED, "%s is not on the ladder.\n", laddername);
					else
						AppendText(IDC_CHATWND, YELLOW, "%s is ranked #%d on the ladder.\n", laddername, ladder);
					break;
				case 0x0a:
					strcpy(unname, buffer + 4);
					AppendText(IDC_CHATWND, WHITE, "%s", timestamp);
					AppendText(IDC_CHATWND, LIGHTBLUE, "Logged on as %s\r\n", unname);
					idletimer = GetTickCount() + 180000;
					lasttick = GetTickCount();
					idletime = 0;
					break;
				case 0x0b:
					memcpy(channels, buffer + 4, packetlen - 4);
					channelslen = packetlen - 4;
					break;
				case 0x33:
					lastreply = true;
					break;
				case 0x0f:
					switch(buffer[4])
					{
					case 0x01:
						getvalues(buffer, &ping, &flags, name, txt);
						ParseStatstring(txt, stats);
						InsertItem(IDC_CHANLIST, name, GetIconCode(txt, flags));
						strncpy(prog, txt, 4);
						AddListBoxItem(IDC_PROGLIST, prog);
						AppendText(IDC_CHATWND, WHITE, "%s", timestamp);
						AppendText(IDC_CHATWND, GRAY, "In channel %s:%x:%d, using %s\n", name, flags, ping, stats);
						break;
					case 0x02:
						getvalues(packetdata, &ping, &flags, name, txt);
						ParseStatstring(txt, stats);
						strncpy(prog, txt, 4);
						AddListBoxItem(IDC_PROGLIST, prog);
						InsertItem(IDC_CHANLIST, name, GetIconCode(txt, flags));
						AppendText(IDC_CHATWND, WHITE, "%s", timestamp);
						AppendText(IDC_CHATWND, DARKGREEN, "%s:%x:%d joined the channel using %s\n", name, flags, ping, stats);
						break;
					case 0x03:
						getvalues(packetdata, &ping, &flags, name, txt);
						RemoveListBoxItem(IDC_PROGLIST, GetItemIndex(IDC_CHANLIST, name));
						RemoveItem(IDC_CHANLIST, name);
						AppendText(IDC_CHATWND, WHITE, "%s", timestamp);
						AppendText(IDC_CHATWND, DARKGREEN, "%s has left the channel.\n", name);
						break;
					case 0x04:
						getvalues(packetdata, &ping, &flags, name, txt);
						AppendText(IDC_CHATWND, WHITE, "%s", timestamp);
						AppendText(IDC_CHATWND, GREEN, "%s:%x:%d: whispers: ", name, flags, ping);
						AppendText(IDC_CHATWND, GRAY, "%s\n", txt);
						strcpy(replyname, name);
						break;
					case 0x05:
						getvalues(packetdata, &ping, &flags, name, txt);
						if(txt[0] == '')
						{
							AppendText(IDC_CHATWND, WHITE, "%s", timestamp);
							AppendText(IDC_CHATWND, LIGHTBLUE, "Decrypted from %s: ", name);
							AppendText(IDC_CHATWND, WHITE, "%s\n", Decrypt(txt + 1));
							break;
						}
						if(txt[0] == '')
						{
							AppendText(IDC_CHATWND, WHITE, "%s", timestamp);
							AppendText(IDC_CHATWND, LIGHTBLUE, "Hexchat %s: ", name);
							Translate(txt + 1);
							AppendText(IDC_CHATWND, WHITE, "%s\n", txt + 1);
							break;
						}
						AppendText(IDC_CHATWND, WHITE, "%s", timestamp);
						if(flags % 10 > 0 && flags % 10 != 6)
							AppendText(IDC_CHATWND, WHITE, "<%s> ", name);
						else
							AppendText(IDC_CHATWND, GREEN, "<%s> ", name);
							AppendText(IDC_CHATWND, WHITE, "%s\n", txt);
						break;
					case 0x07:
						getvalues(packetdata, &ping, &flags, name, txt);
						ClearListView(IDC_CHANLIST);
						ClearListBox(IDC_PROGLIST);
						strcpy(currentchannel, txt);
						SetEditBoxText(IDC_CHAN, txt);
						AppendText(IDC_CHATWND, WHITE, "%s", timestamp);
						AppendText(IDC_CHATWND, LIGHTBLUE, "Joined %s (flags: 0x%x)\n", txt, flags);
						break;
					case 0x09:
						getvalues(packetdata, &ping, &flags, name, txt);
						GetListBoxItemText(IDC_PROGLIST, GetItemIndex(IDC_CHANLIST, name), prog);
						ModifyItem(IDC_CHANLIST, name, GetIconCode(prog, flags));
						if(flags & 0x02){
							AppendText(IDC_CHATWND, WHITE, "%s", timestamp);
							if(!stricmp(unname, name))
								AppendText(IDC_CHATWND, LIGHTBLUE, "You have acquired operator status.\n");
							else
								AppendText(IDC_CHATWND, LIGHTBLUE, "%s has acquired operator status.\n", name);
						}
						break;
					case 0x0a:
						getvalues(packetdata, &ping, &flags, name, txt);
						AppendText(IDC_CHATWND, WHITE, "%s", timestamp);
						AppendText(IDC_CHATWND, GREEN, "You whisper to %s:%x:%d: ", name, flags, ping);
						AppendText(IDC_CHATWND, GRAY, "%s\n", txt);
						break;
					case 0x12:
						getvalues(packetdata, &ping, &flags, name, txt);
						AppendText(IDC_CHATWND, WHITE, "%s", timestamp);
						AppendText(IDC_CHATWND, YELLOW, "Broadcast: %s\n", txt);
						break;
					case 0x13:
						getvalues(packetdata, &ping, &flags, name, txt);
						AppendText(IDC_CHATWND, WHITE, "%s", timestamp);
						AppendText(IDC_CHATWND, RED, "Error: %s\n", txt);
						break;
					case 0x17:
						getvalues(packetdata, &ping, &flags, name, txt);
						AppendText(IDC_CHATWND, WHITE, "%s", timestamp);
						AppendText(IDC_CHATWND, YELLOW, "* %s %s *\n", name, txt);
						break;			
					}
					break;
				}
				if((int)buflen - (int)packetlen < 0) buflen += packetlen;
				if((int)buflen - (int)packetlen >= 0)
					memmove(buffer, buffer + packetlen, buflen - packetlen);
				buflen -= packetlen;
				DoEvents();
			}
		}
		DoEvents();
	}
}

void getvalues(const char *databuf, DWORD *ping, DWORD *flags, char *name, char *txt)
{
	DWORD a, b, c, d, e, f, recvbufpos = 4;
	f = *(unsigned long *)(databuf + recvbufpos);
	recvbufpos+=4;
	a = *(unsigned long *)(databuf + recvbufpos);
	recvbufpos+=4;
	b = *(unsigned long *)(databuf + recvbufpos);
	recvbufpos+=4;
	c = *(unsigned long *)(databuf + recvbufpos);
	recvbufpos+=4;
	d = *(unsigned long *)(databuf + recvbufpos);
	recvbufpos+=4;
	e = *(unsigned long *)(databuf + recvbufpos);
	recvbufpos+=4;
	*flags = a;
	*ping = b;
	strcpy(name, databuf + 28);
	strcpy(txt, databuf + (strlen(name) + 29));
}

void datahash(unsigned long*param)
{
	unsigned long buf[0x50];
	unsigned long dw, a, b, c, d, e, *p;
	int i;
	memcpy(buf, param+5, 0x40);
	for(i=0x10; i<0x50; i++) 
	{
		dw = buf[i-0x10]^buf[i-0x8]^buf[i-0xe]^buf[i-0x3];
		buf[i] = (1>>(0x20-(unsigned char)dw)) | (1<<(unsigned char)dw);		
	}
	a = param[0];	// edi
	b = param[1];	// eax
	c = param[2];	// esi
	d = param[3];	// edx
	e = param[4];	// [+18], ebx
	p = buf;		// [+14]
	i = 0x14;		// [+10]
	do 
	{
		dw = ((a<<5) | (a>>0x1b)) + ((~b & d) | (c & b)) + e + *p++ + 0x5A827999; // ecx
		e = d;
		d = c;
		c = (b>>2)  | (b<<0x1e);
		b = a;
		a = dw;
	} while(--i);
	i = 0x14;		// [+14]
	do 
	{
		dw = (d ^ c ^ b) + e + ((a<<5) | (a>>0x1b)) + *p++ + 0x6ED9EBA1; // ecx
		e = d;
		d = c;
		c = (b>>2) | (b<<0x1e);
		b = a;
		a = dw;
	} while(--i);
	i = 0x14;
	do 
	{
		dw = ((c & b) | (d & c) | (d & b)) + e + ((a<<5) | (a>>0x1b)) + *p++ - 0x70E44324; // ecx
		e = d;
		d = c;
		c = (b>>2) | (b<<0x1e);
		b = a;
		a = dw;
	} while(--i);

	i = 0x14;
	do 
	{
		dw = ((a<<5) | (a>>0x1b)) + e + (d ^ c ^ b) + *p++ - 0x359D3E2A; // ecx
		e = d;
		d = c;
		c = (b>>2) | (b<<0x1e);
		b = a;
		a = dw;
	} while(--i);
	param[0] += a;
	param[1] += b;
	param[2] += c;
	param[3] += d;
	param[4] += e;

}

void calchashbuf(unsigned long *hash, void *inbuf, int len)
{
	char *buf = (char*)inbuf;
	int pos;
	int sublen;
	unsigned long hashbuf[0x10 + 5];
	hashbuf[0] = 0x67452301;
	hashbuf[1] = 0xEFCDAB89;
	hashbuf[2] = 0x98BADCFE;
	hashbuf[3] = 0x10325476;
	hashbuf[4] = 0xC3D2E1F0;
	for(pos=0; pos<len; pos+=0x40) {
		sublen = len - pos;
		if(sublen > 0x40)
			sublen = 0x40;
		memcpy(hashbuf+5, buf+pos, sublen);
		if(sublen<0x40)
			ZeroMemory((char*)(hashbuf+5)+sublen, 0x40-sublen);
		datahash(hashbuf);
	}
	memcpy(hash, hashbuf, 5*4);
}

BOOL CheckRevision(LPCTSTR lpszFileName1, LPCTSTR lpszFileName2, LPCTSTR lpszFileName3, LPCTSTR lpszValueString, DWORD * lpdwVersion, DWORD * lpdwChecksum, LPSTR lpExeInfoString, LPCTSTR lpszMpqFileName)
{
   DWORD dwMpqChecksumKeys[] = {0xE7F4CB62lu, 0xF6A14FFClu, 0xAA5504AFlu, 0x871FCDC2lu, 0x11BF6A18lu, 0xC57292E6lu, 0x7927D27Elu, 0x2FEC8733lu};
   HANDLE hFile, hFileMapping;
   char * s, lpszFileName[256], cOperations[16];
   int nHashFile, nVariable1[16], nVariable2[16], nVariable3[16], nVariable,
       i, k, nHashOperations;
   DWORD dwTotalSize, dwSize, j, dwBytesRead, dwVariables[4], dwMpqKey,
         * lpdwBuffer;
   LPSTR lpszFileNames[3];
   FILETIME ft;
   SYSTEMTIME st;
   LPBYTE lpbBuffer;
   VS_FIXEDFILEINFO * ffi;

   s = strchr((char *) lpszMpqFileName, '.');
   if (s == NULL)
      return FALSE;
   nHashFile = (int) (*(s - 1) - '0');
   if (nHashFile > 7 || nHashFile < 0)
      return FALSE;
   dwMpqKey = dwMpqChecksumKeys[nHashFile];
   lpszFileNames[0] = (LPSTR) lpszFileName1;
   lpszFileNames[1] = (LPSTR) lpszFileName2;
   lpszFileNames[2] = (LPSTR) lpszFileName3;
   s = (char *) lpszValueString;
   while (*s != '\0')
   {
      if (isalpha(*s))
         nVariable = (int) (toupper(*s) - 'A');
      else
      {
         nHashOperations = (int) (*s - '0');
         s = strchr(s, ' ');
         if (s == NULL)
            return FALSE;
         s++;
         break;
      }
      if (*(++s) == '=')
         s++;
      dwVariables[nVariable] = atol(s);
      s = strchr(s, ' ');
      if (s == NULL)
         return FALSE;
      s++;
   }
   for (i = 0; i < nHashOperations; i++)
   {
      if (!isalpha(*s))
         return FALSE;
      nVariable1[i] = (int) (toupper(*s) - 'A');
      if (*(++s) == '=')
         s++;
      if (toupper(*s) == 'S')
         nVariable2[i] = 3;
      else
         nVariable2[i] = (int) (toupper(*s) - 'A');
      cOperations[i] = *(++s);
      s++;
      if (toupper(*s) == 'S')
         nVariable3[i] = 3;
      else
         nVariable3[i] = (int) (toupper(*s) - 'A');
      s = strchr(s, ' ');
      if (s == NULL)
         break;
      s++;
   }
   dwVariables[0] ^= dwMpqKey;
   for (i = 0; i < 3; i++)
   {
      if (lpszFileNames[i][0] == '\0')
         continue;
      hFile = CreateFile(lpszFileNames[i],
                         GENERIC_READ,
                         FILE_SHARE_READ,
                         NULL,
                         OPEN_EXISTING,
                         FILE_ATTRIBUTE_NORMAL,
                         NULL);
      if (hFile == (HANDLE) INVALID_HANDLE_VALUE)
         return FALSE;
      hFileMapping = CreateFileMapping(hFile, NULL, PAGE_READONLY, 0, 0, NULL);
      if (hFileMapping == NULL)
      {
         CloseHandle(hFile);
         return FALSE;
      }
      lpdwBuffer = (LPDWORD) MapViewOfFile(hFileMapping, FILE_MAP_READ, 0, 0, 0);
      if (lpdwBuffer == NULL)
      {
         CloseHandle(hFileMapping);
         CloseHandle(hFile);
         return FALSE;
      }
      if (i == 0)
      {
         GetFileTime(hFile, NULL, NULL, &ft);
         FileTimeToSystemTime(&ft, &st);
         dwTotalSize = GetFileSize(hFile, NULL);
      }
      dwSize = (GetFileSize(hFile, NULL) / 1024lu) * 1024lu;
      for (j = 0; j < (dwSize / 4lu); j++)
      {
         dwVariables[3] = lpdwBuffer[j];
         for (k = 0; k < nHashOperations; k++)
         {
            switch (cOperations[k])
            {
               case '+':
                  dwVariables[nVariable1[k]] = dwVariables[nVariable2[k]] +
                                               dwVariables[nVariable3[k]];
                  break;
               case '-':
                  dwVariables[nVariable1[k]] = dwVariables[nVariable2[k]] -
                                               dwVariables[nVariable3[k]];
                  break;
               case '^':
                  dwVariables[nVariable1[k]] = dwVariables[nVariable2[k]] ^
                                               dwVariables[nVariable3[k]];
                  break;
               default:
                  return FALSE;
            }
         }
      }
      UnmapViewOfFile(lpdwBuffer);
      CloseHandle(hFileMapping);
      CloseHandle(hFile);
   }
   strcpy(lpszFileName, lpszFileName1);
   dwSize = GetFileVersionInfoSize(lpszFileName, &dwBytesRead);
   lpbBuffer = (LPBYTE) VirtualAlloc(NULL, dwSize, MEM_COMMIT,
                                     PAGE_READWRITE);
   if (lpbBuffer == NULL)
      return FALSE;
   if (GetFileVersionInfo(lpszFileName, NULL, dwSize, lpbBuffer) == FALSE)
      return FALSE;
   if (VerQueryValue(lpbBuffer, "\\", (LPVOID *) &ffi, (PUINT) &dwSize) == FALSE)
      return FALSE;
   *lpdwVersion = ((HIWORD(ffi->dwProductVersionMS) & 0xFF) << 24) |
                  ((LOWORD(ffi->dwProductVersionMS) & 0xFF) << 16) |
                  ((HIWORD(ffi->dwProductVersionLS) & 0xFF) << 8) |
                  (LOWORD(ffi->dwProductVersionLS) & 0xFF);
   VirtualFree(lpbBuffer, 0lu, MEM_RELEASE);
   s = (char *) &lpszFileName[strlen(lpszFileName)-1];
   while (*s != '\\' && s > (char *) lpszFileName)
      s--;
   s++;
   sprintf(lpExeInfoString,
           "%s %02u/%02u/%02u %02u:%02u:%02u %lu",
           lpszFileName + 5,
           st.wMonth,
           st.wDay,
           st.wYear % 100,
           st.wHour,
           st.wMinute,
           st.wSecond,
           dwTotalSize);
   *lpdwChecksum = dwVariables[2];
   return TRUE;
}

void TimeStamp(char *buf)
{
	SYSTEMTIME st;
	GetLocalTime(&st);
	sprintf(buf, "[%02i:%02i:%02i]  ", st.wHour, st.wMinute, st.wSecond);
}

void RequestProfile(const char *username)
{
	prof++;
	packetbuf.insert((int)1);
	packetbuf.insert((int)4);
	packetbuf.insert((int)prof);
	packetbuf.insert(username);
	packetbuf.insert("profile\\age");
	packetbuf.insert("profile\\sex");
	packetbuf.insert("profile\\location");
	packetbuf.insert("profile\\description");
	packetbuf.sendpacket(s, 0x26);
}

void DisplayProfileDialog(char *databuf)
{
	int packetpos = 4 * sizeof(DWORD);
	strcpy(age, databuf + packetpos);
	packetpos += (strlen(age) + 1);
	strcpy(sex, databuf + packetpos);
	packetpos += (strlen(sex) + 1);
	strcpy(location, databuf + packetpos);
	packetpos += (strlen(location) + 1);
	strcpy(description, databuf + packetpos);
	CreateDialog(DlgInst, MAKEINTRESOURCE(IDD_PROFILE), Dlg, ProfileDialogProc);
}

unsigned cpuspeed(void)
{
    unsigned __int64 start, stop;
    unsigned total;
    start = GetCycleCount();
    Sleep(1000);
    stop = GetCycleCount();
    stop = stop - start;
    total = (unsigned)(stop/1000000);
    return total;
}

unsigned __int64 GetCycleCount(void)
{
    _asm _emit 0x0F
    _asm _emit 0x31
}

unsigned FixSpeed(unsigned CpuSpeed)
{
	unsigned tmp = CpuSpeed;
	if(tmp > 100)
		while(tmp > 100)
			tmp-=100;
	if((tmp % 33 < tmp % 50))
		return CpuSpeed - (tmp % 33);
	else
		return CpuSpeed - (tmp % 50);
}

SYSTEMTIME FormatDWORD(DWORD Milliseconds)
{
	SYSTEMTIME a;
	a.wSecond = Milliseconds / 1000;
	a.wMinute = (Milliseconds / 1000) / 60;
	a.wHour = ((Milliseconds / 1000) / 60) / 60;
	a.wDay = (((Milliseconds / 1000) / 60) / 60) / 24;
	a.wHour %= 24;
	a.wMinute %= 60;
	a.wSecond %= 60;
	return a;
}

void HexDump(int len, char *buf) {
  char tmp[ 128];
  for (int offset = 0; offset < len; offset += 16) {
    sprintf( tmp, "%08X   ", offset); AppendText(IDC_CHATWND, WHITE, "%s", tmp);
    unsigned char *p = (unsigned char *)(buf + offset);
    int stop = ((offset + 16) > len) ? len - offset : 16;

    int i = 0;
    for (; i < stop; i++) {
      if (i == 8) AppendText(IDC_CHATWND, WHITE, "- ");
      sprintf( tmp, "%02X ", p[i]);
      AppendText(IDC_CHATWND, WHITE, "%s", tmp);
    }

    while (i < 16) {
      if (i++ == 8) AppendText(IDC_CHATWND, WHITE, "- ");
      AppendText(IDC_CHATWND, WHITE, "   ");
    }

    AppendText(IDC_CHATWND, WHITE, "  ");

    for (i = 0; i < stop; i++)
      tmp[i] = isgraph(p[i]) ? p[i] : p[i] == ' ' ? ' ' : '.';
    tmp[i] = 0;
    AppendText(IDC_CHATWND, WHITE, "%s\n", tmp);
  }
}
